/*
 * Decompiled with CFR 0.152.
 */
package com.hellmessage.core.tools;

import com.hellmessage.core.nbt.tag.ByteTag;
import com.hellmessage.core.nbt.tag.CompoundTag;
import com.hellmessage.core.nbt.tag.IntTag;
import com.hellmessage.core.nbt.tag.ListTag;
import com.hellmessage.core.nbt.tag.StringTag;
import com.hellmessage.core.nbt.tag.Tag;
import com.hellmessage.core.util.Materials;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.SkullType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class HESkulls {
    private static HashMap<String, ItemStack> skulls = new HashMap();
    private static final Map<Integer, SkullType> skullTypeMap = new HashMap<Integer, SkullType>();
    private static final Map<Integer, BlockFace> skullRotationMap = new HashMap<Integer, BlockFace>();

    public static ItemStack getSkull(String texture) {
        return skulls.computeIfAbsent(texture, h -> HESkulls.setTexture(Materials.PLAYER_HEAD.parseItem(), texture));
    }

    private static ItemStack setTexture(ItemStack skull, String texture) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        try {
            SkullMeta meta = (SkullMeta)skull.getItemMeta();
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture, null));
            Field field = meta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            field.set(meta, profile);
            skull.setItemMeta((ItemMeta)meta);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return skull;
    }

    public static String getTexture(ItemStack skull) {
        ItemMeta meta = skull.getItemMeta();
        try {
            Field field = meta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            GameProfile profile = (GameProfile)field.get(meta);
            if (profile != null) {
                for (Property prop : profile.getProperties().values()) {
                    if (!"textures".equals(prop.getName())) continue;
                    return prop.getValue();
                }
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setSkullBlock(Block block, Map<String, Tag> tags, byte data) {
        int rot;
        int standing;
        byte type;
        if (!(block.getState() instanceof Skull)) {
            return;
        }
        if (tags == null) {
            return;
        }
        Skull skull = (Skull)block.getState();
        SkullType skullType = skullTypeMap.get(0);
        BlockFace blockFace = skullRotationMap.get(0);
        String ownerUUID = null;
        String ownerName = null;
        String skullTexture = null;
        String skullSignature = null;
        if (tags.containsKey("SkullType") && skullTypeMap.containsKey(type = ((ByteTag)tags.get("SkullType")).getValue().byteValue())) {
            skullType = skullTypeMap.get(type);
        }
        if (data > 0 && data < 6) {
            standing = data;
            if (tags.containsKey("Rot")) {
                rot = ((ByteTag)tags.get("Rot")).getValue().byteValue();
                if (skullRotationMap.containsKey(standing)) {
                    blockFace = skullRotationMap.get(rot);
                }
            }
        } else {
            standing = 2;
            if (tags.containsKey("Rot")) {
                rot = ((IntTag)tags.get("Rot")).getValue();
                if (skullRotationMap.containsKey(standing)) {
                    blockFace = skullRotationMap.get(rot);
                }
            }
        }
        if (skullType.equals((Object)SkullType.PLAYER) && tags.containsKey("Owner")) {
            ListTag list;
            Object prop;
            Object owner = ((CompoundTag)tags.get("Owner")).getValue();
            if (owner.containsKey("Name")) {
                ownerName = ((StringTag)owner.get("Name")).getValue();
            }
            if (owner.containsKey("Id")) {
                ownerUUID = ((StringTag)owner.get("Id")).getValue();
            }
            if (owner.containsKey("Properties") && (prop = ((CompoundTag)owner.get("Properties")).getValue()).containsKey("textures") && (list = (ListTag)prop.get("textures")) != null) {
                Object texture = ((CompoundTag)list.getValue().get(0)).getValue();
                if (texture.containsKey("Value")) {
                    skullTexture = ((StringTag)texture.get("Value")).getValue();
                }
                if (texture.containsKey("Signature")) {
                    skullSignature = ((StringTag)texture.get("Signature")).getValue();
                }
            }
        }
        if (ownerName != null) {
            skull.setOwner(ownerName);
        }
        skull.setRotation(blockFace);
        skull.setRawData((byte)standing);
        skull.setSkullType(skullType);
        if (skullTexture != null) {
            skull.getWorld().refreshChunk(skull.getChunk().getX(), skull.getChunk().getZ());
            GameProfile profile = new GameProfile(ownerUUID == null ? UUID.randomUUID() : UUID.fromString(ownerUUID), ownerName);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", skullTexture, skullSignature));
            try {
                Field field = skull.getClass().getDeclaredField("profile");
                field.setAccessible(true);
                field.set(skull, profile);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        skull.update(true, false);
    }

    static {
        skullTypeMap.put(0, SkullType.SKELETON);
        skullTypeMap.put(1, SkullType.WITHER);
        skullTypeMap.put(2, SkullType.ZOMBIE);
        skullTypeMap.put(3, SkullType.PLAYER);
        skullTypeMap.put(4, SkullType.CREEPER);
        skullRotationMap.put(0, BlockFace.NORTH);
        skullRotationMap.put(1, BlockFace.NORTH_NORTH_EAST);
        skullRotationMap.put(2, BlockFace.NORTH_EAST);
        skullRotationMap.put(3, BlockFace.EAST_NORTH_EAST);
        skullRotationMap.put(4, BlockFace.EAST);
        skullRotationMap.put(5, BlockFace.EAST_SOUTH_EAST);
        skullRotationMap.put(6, BlockFace.SOUTH_EAST);
        skullRotationMap.put(7, BlockFace.SOUTH_SOUTH_EAST);
        skullRotationMap.put(8, BlockFace.SOUTH);
        skullRotationMap.put(9, BlockFace.SOUTH_SOUTH_WEST);
        skullRotationMap.put(10, BlockFace.SOUTH_WEST);
        skullRotationMap.put(11, BlockFace.WEST_SOUTH_WEST);
        skullRotationMap.put(12, BlockFace.WEST);
        skullRotationMap.put(13, BlockFace.WEST_NORTH_WEST);
        skullRotationMap.put(14, BlockFace.NORTH_WEST);
        skullRotationMap.put(15, BlockFace.NORTH_NORTH_WEST);
    }
}

