/*
 * Decompiled with CFR 0.152.
 */
package com.hellmessage.core.tools;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HERegex {
    public static boolean match(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static boolean isZh(String str) {
        String regex = "[\\u4e00-\\u9fa5]";
        return HERegex.match(regex, str);
    }

    public static boolean isMobile(String mobile) {
        String regex = "^(1[3-9])\\d{9}$";
        return HERegex.match(regex, mobile);
    }

    public static boolean isUrl(String url) {
        String regex = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?";
        return HERegex.match(regex, url);
    }

    public static boolean isMail(String mail) {
        String regex = "^([\\w-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([\\w-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$";
        return HERegex.match(regex, mail);
    }

    public static boolean isZero(String str) {
        String regex = "^\\+?[1-9][0-9]*$";
        return !HERegex.match(regex, str);
    }

    public static boolean isFloat(String str) {
        String regex = "^[0-9]+(.[0-9]+)?$";
        return HERegex.match(regex, str);
    }

    public static boolean isIp(String str) {
        String num = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";
        String regex = String.format("^%s\\.%s\\.%s\\.%s$", num, num, num, num);
        return HERegex.match(regex, str);
    }

    public static boolean isNumber(String str) {
        boolean isInt = Pattern.compile("^-?[1-9]\\d*$").matcher(str).find();
        boolean isDouble = Pattern.compile("^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$").matcher(str).find();
        return isInt || isDouble;
    }

    public static boolean isInt(String str) {
        return Pattern.compile("^-?[1-9]\\d*$").matcher(str).find();
    }

    public static boolean isDouble(String str) {
        return Pattern.compile("^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$").matcher(str).find();
    }
}

