/*
 * Decompiled with CFR 0.152.
 */
package com.hellmessage.core.file;

import com.hellmessage.core.annotation.HEBranch;
import com.hellmessage.core.annotation.HEEntity;
import com.hellmessage.core.annotation.HEMap;
import com.hellmessage.core.annotation.HENode;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class HEConfig {
    private String path = null;
    private String name;
    private JavaPlugin instance;
    private FileConfiguration config;

    public HEConfig(JavaPlugin instance, String name) {
        this.instance = instance;
        this.name = name;
        this.init();
    }

    public HEConfig(JavaPlugin instance, String name, String path) {
        this.instance = instance;
        this.path = path;
        this.name = name;
        this.init();
    }

    private void init() {
        File ConfigFile;
        String fileName = this.name;
        if (this.path != null && !this.path.equals("")) {
            fileName = String.format("%s/%s", this.path, this.name);
        }
        if (!(ConfigFile = new File(this.instance.getDataFolder(), fileName)).exists()) {
            this.instance.saveResource(fileName, false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)ConfigFile);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public static FileConfiguration get(JavaPlugin instance, String name) {
        return new HEConfig(instance, name).getConfig();
    }

    public static FileConfiguration get(JavaPlugin instance, String name, String path) {
        return new HEConfig(instance, name, path).getConfig();
    }

    public static <T> T get(JavaPlugin plugin, Class<T> cs) throws Exception {
        HEEntity entity = cs.getAnnotation(HEEntity.class);
        if (entity == null) {
            return null;
        }
        String name = entity.value();
        String path = entity.path();
        return HEConfig.get(plugin, name, path, cs);
    }

    public static <T> T get(JavaPlugin plugin, String name, String path, Class<T> cs) throws Exception {
        FileConfiguration config = HEConfig.get(plugin, name, path);
        if (config == null) {
            return null;
        }
        String base = "";
        HENode node = cs.getAnnotation(HENode.class);
        if (node != null) {
            base = String.format("%s.", node.value());
        }
        return HEConfig.handleClass(plugin, config, base, cs);
    }

    private static <T> T handleClass(JavaPlugin plugin, FileConfiguration config, String base, Class<T> cs) throws Exception {
        T object = cs.newInstance();
        for (Field field : object.getClass().getDeclaredFields()) {
            MemorySection memory;
            field.setAccessible(true);
            HEBranch branch = field.getAnnotation(HEBranch.class);
            if (branch != null && !branch.value().isEmpty()) {
                field.set(object, HEConfig.getBranch(plugin, config, String.format("%s%s.", base, branch.value()), field.getType()));
                continue;
            }
            HENode node = field.getAnnotation(HENode.class);
            if (node != null && !node.value().isEmpty()) {
                field.set(object, config.get(String.format("%s%s", base, node.value()), field.get(object)));
                continue;
            }
            HEMap map = field.getAnnotation(HEMap.class);
            if (map == null || map.value().isEmpty() || (memory = (MemorySection)config.get(String.format("%s%s", base, map.value()))) == null) continue;
            HashMap hash = new HashMap();
            memory.getKeys(false).forEach(item -> {
                try {
                    Class<?> c1 = Class.forName(map.type());
                    Object obj = HEConfig.handleClass(plugin, config, String.format("%s%s.%s.", base, map.value(), item), c1);
                    hash.put(item, c1.cast(obj));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            field.set(object, hash);
        }
        return object;
    }

    private static <T> T getBranch(JavaPlugin plugin, FileConfiguration config, String base, Class<T> cs) throws Exception {
        HENode node = cs.getAnnotation(HENode.class);
        if (node != null) {
            base = String.format("%s%s.", base, node.value());
        }
        return HEConfig.handleClass(plugin, config, base, cs);
    }
}

