/*
 * Decompiled with CFR 0.152.
 */
package com.hellmessage.core.database.util;

import com.hellmessage.core.database.util.FieldType;

public class SQLParam {
    private String name;
    private String column;
    private String type;
    private String def;
    private boolean autoInCrement;
    private boolean primaryKey;

    public SQLParam() {
    }

    public SQLParam(String name, String type) {
        this(name, type, false, false);
    }

    public SQLParam(String name, String type, boolean autoInCrement, boolean primaryKey) {
        this.name = name;
        this.type = type;
        this.autoInCrement = autoInCrement;
        this.primaryKey = primaryKey;
        if (autoInCrement) {
            this.type = FieldType.INTEGER.getType();
            this.primaryKey = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDef() {
        return this.def;
    }

    public void setDef(String def) {
        this.def = def;
    }

    public boolean isAutoInCrement() {
        return this.autoInCrement;
    }

    public void setAutoInCrement(boolean autoInCrement) {
        this.autoInCrement = autoInCrement;
        if (autoInCrement) {
            this.type = FieldType.INTEGER.getType();
            this.primaryKey = true;
        }
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String toString() {
        return String.format("HESQLParam{name='%s', column='%s', type='%s', autoInCrement=%s, primaryKey=%s}", this.name, this.column, this.type, this.autoInCrement, this.primaryKey);
    }
}

