/*
 * Decompiled with CFR 0.152.
 */
package com.hellmessage.core.database.drives.sqlite;

import com.hellmessage.core.database.annotation.HEColumn;
import com.hellmessage.core.database.annotation.HETable;
import com.hellmessage.core.database.drives.SQLTable;
import com.hellmessage.core.database.drives.SQLTableManage;
import com.hellmessage.core.database.util.ComparatorUtil;
import com.hellmessage.core.database.util.FieldType;
import com.hellmessage.core.database.util.SQLParam;
import com.hellmessage.core.util.HETextUtil;
import java.lang.reflect.Field;

public class SQLiteResolver {
    public SQLiteResolver(SQLTable table, Class<?> cs) {
        this.parse(table, cs);
    }

    private void parse(SQLTable table, Class<?> cs) {
        if (cs == null) {
            return;
        }
        this.parseTableName(table, cs);
        this.parseTableParams(table, cs);
        this.sort(table);
        table.setCreateTableStatement(this.getCreateTableStatement(table));
        SQLTableManage.getInstance().put(table);
    }

    private void parseTableName(SQLTable table, Class<?> cs) {
        HETable ano = cs.getAnnotation(HETable.class);
        if (ano == null) {
            throw new RuntimeException("\u65e0\u914d\u7f6e\u6620\u5c04\u8868\u540d");
        }
        table.setTableName(ano.name());
        if (HETextUtil.isEmpty(table.getTableName())) {
            throw new NullPointerException("\u6620\u5c04\u8868\u540d\u4e0d\u5f97\u4e3a\u7a7a");
        }
    }

    private void parseTableParams(SQLTable table, Class<?> cs) {
        Field[] fields = cs.getDeclaredFields();
        if (fields.length == 0) {
            throw new NullPointerException("\u8bf7\u4e3a\u8868\u8bbe\u8ba1\u5b57\u6bb5");
        }
        table.getColumnParams().clear();
        for (Field field : fields) {
            this.parseField(field, table);
        }
    }

    private void parseField(Field field, SQLTable table) {
        HEColumn ano = field.getAnnotation(HEColumn.class);
        if (ano == null) {
            return;
        }
        SQLParam param = new SQLParam();
        String column = ano.name();
        String name = field.getName();
        param.setName(name);
        if (HETextUtil.isEmpty(column)) {
            param.setColumn(name);
        } else {
            param.setColumn(column);
        }
        param.setDef(null);
        if (!ano.def().isEmpty()) {
            if (ano.type().equals((Object)FieldType.INTEGER)) {
                try {
                    Integer.valueOf(ano.def());
                    param.setDef(ano.def());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (ano.type().equals((Object)FieldType.TEXT)) {
                param.setDef(ano.def());
            }
        }
        param.setType(ano.type().getType());
        param.setAutoInCrement(ano.autoInCrement());
        param.setPrimaryKey(ano.primaryKey());
        table.getColumnParams().add(param);
    }

    private void sort(SQLTable table) {
        if (table.getColumnParams().size() != 0) {
            table.getColumnParams().sort(new ComparatorUtil());
        }
    }

    public String getCreateTableStatement(SQLTable table) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE IF NOT EXISTS ").append(table.getTableName()).append(" (");
        for (int i = 0; i < table.getColumnParams().size(); ++i) {
            SQLParam param = table.getParamByIndex(i);
            sb.append(param.getColumn()).append(" ").append(param.getType());
            if (param.isAutoInCrement() || param.isPrimaryKey()) {
                if (param.isAutoInCrement()) {
                    sb.append(" PRIMARY KEY AUTOINCREMENT");
                } else if (param.isPrimaryKey()) {
                    sb.append(" PRIMARYKEY");
                }
            } else if (param.getDef() != null && !param.getDef().isEmpty()) {
                if (param.getType().equals(FieldType.TEXT.getType())) {
                    sb.append(" DEFAULT '").append(param.getDef()).append("'");
                } else if (param.getType().equals(FieldType.INTEGER.getType())) {
                    sb.append(" DEFAULT ").append(param.getDef());
                }
            }
            if (i >= table.getColumnParams().size() - 1) continue;
            sb.append(",");
        }
        sb.append(");");
        return sb.toString();
    }
}

