/*
 * Decompiled with CFR 0.152.
 */
package com.hellmessage.core.database.drives.sqlite;

import com.hellmessage.core.database.IHEDao;
import com.hellmessage.core.database.drives.SQLTable;
import com.hellmessage.core.database.drives.SQLTableManage;
import com.hellmessage.core.database.util.FieldType;
import com.hellmessage.core.database.util.SQLParam;
import com.hellmessage.core.util.HETextUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class SQLiteDao
implements IHEDao {
    private Connection connection;
    private Statement statement;

    public SQLiteDao(String db, String username, String password) throws SQLException, ClassNotFoundException {
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", db), username, password);
        this.statement = this.connection.createStatement();
    }

    @Override
    public int execSQL(String sql) throws SQLException {
        return this.statement.executeUpdate(sql);
    }

    @Override
    public void insert(Object object) throws SQLException, NoSuchFieldException, IllegalAccessException {
        SQLTable table = SQLTableManage.getInstance().get(object.getClass());
        if (table == null) {
            throw new SQLException("table \u672a\u88ab\u7ba1\u7406\u5668\u52a0\u8f7d");
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(table.getTableName());
        StringBuilder ks = new StringBuilder(" (");
        StringBuilder vs = new StringBuilder(" (");
        for (int i = 0; i < table.getColumnParams().size(); ++i) {
            SQLParam param = table.getParamByIndex(i);
            if (param.isPrimaryKey()) continue;
            ks.append(param.getColumn());
            Field field = object.getClass().getDeclaredField(param.getName());
            field.setAccessible(true);
            if (param.getType().equals(FieldType.TEXT.getType())) {
                vs.append("'");
                if (field.get(object) != null) {
                    vs.append(field.get(object));
                } else if (param.getDef() != null) {
                    vs.append(param.getDef());
                }
                vs.append("'");
            } else if (param.getType().equals(FieldType.INTEGER.getType())) {
                if (field.get(object) != null) {
                    vs.append(field.get(object));
                } else if (param.getDef() != null) {
                    vs.append(param.getDef());
                } else {
                    vs.append(0);
                }
            }
            if (i >= table.getColumnParams().size() - 1) continue;
            ks.append(",");
            vs.append(",");
        }
        ks.append(") ");
        vs.append(");");
        sb.append((CharSequence)ks).append("VALUES").append((CharSequence)vs);
        int id = this.execSQL(sb.toString());
        if (id <= 0) {
            throw new SQLException(String.format("\u63d2\u5165\u8868\u5931\u8d25,\u6307\u4ee4:%s", sb.toString()));
        }
    }

    @Override
    public <T> T find(Class<T> cs, Object condition) throws SQLException, IllegalAccessException, NoSuchFieldException, InstantiationException {
        if (!cs.equals(condition.getClass())) {
            throw new SQLException("\u4e0d\u540c\u7c7b\u65e0\u6cd5\u4f7f\u7528\u53cd\u5c04\u67e5\u8be2");
        }
        T obj = this.find(cs, this.entityToWhere(condition));
        if (obj == null) {
            return cs.cast(condition);
        }
        return obj;
    }

    @Override
    public <T> T find(Class<T> cs, String where) throws SQLException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        ArrayList<T> list = this.query(cs, String.format("%s LIMIT 1", where));
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> ArrayList<T> query(Class<T> cs, String where) throws SQLException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        SQLTable table = SQLTableManage.getInstance().get(cs);
        if (table == null) {
            throw new SQLException("table \u672a\u88ab\u7ba1\u7406\u5668\u52a0\u8f7d");
        }
        String sql = String.format("SELECT * FROM %s", table.getTableName());
        if (!HETextUtil.isEmpty(where)) {
            sql = String.format("%s WHERE %s", sql, where);
        }
        ResultSet set = this.statement.executeQuery(sql);
        ArrayList<T> list = new ArrayList<T>();
        while (set.next()) {
            T object = cs.newInstance();
            for (SQLParam param : table.getColumnParams()) {
                Field field = object.getClass().getDeclaredField(param.getName());
                field.setAccessible(true);
                if (param.getType().equals(FieldType.INTEGER.getType())) {
                    field.set(object, set.getInt(param.getColumn()));
                    continue;
                }
                if (!param.getType().equals(FieldType.TEXT.getType())) continue;
                field.set(object, set.getString(param.getColumn()));
            }
            list.add(object);
        }
        return list;
    }

    @Override
    public <T> ArrayList<T> query(Class<T> cs, Object condition) throws SQLException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        return this.query(cs, this.entityToWhere(condition));
    }

    @Override
    public <T> T update(Object object, Class<T> cs) throws SQLException, IllegalAccessException {
        SQLTable table = SQLTableManage.getInstance().get(object.getClass());
        if (table == null) {
            throw new SQLException("table \u672a\u88ab\u7ba1\u7406\u5668\u52a0\u8f7d");
        }
        Field[] fields = object.getClass().getDeclaredFields();
        String where = null;
        StringBuilder sb = new StringBuilder("UPDATE ").append(table.getTableName()).append(" SET ");
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            field.setAccessible(true);
            SQLParam param = table.getParamByFieldName(field.getName());
            if (param.isAutoInCrement() && param.isPrimaryKey() && where == null) {
                where = String.format("%s=%s", param.getColumn(), Integer.valueOf(String.valueOf(field.get(object))));
                continue;
            }
            sb.append(param.getColumn()).append("=");
            if (param.getType().equals(FieldType.TEXT.getType())) {
                sb.append("'").append(field.get(object) != null ? field.get(object) : "").append("'");
            } else if (param.getType().equals(FieldType.INTEGER.getType()) && field.get(object) != null) {
                sb.append(Integer.valueOf(String.valueOf(field.get(object))));
            }
            if (i >= fields.length - 1) continue;
            sb.append(",");
        }
        sb.append(" WHERE ").append(where);
        int id = this.execSQL(sb.toString());
        if (id <= 0) {
            throw new SQLException(String.format("\u66f4\u65b0\u8868\u6570\u636e\u5931\u8d25,\u6307\u4ee4:%s", sb.toString()));
        }
        return cs.cast(object);
    }

    @Override
    public void delete(Object object) throws SQLException, NoSuchFieldException, IllegalAccessException {
        int id;
        String str;
        SQLTable table = SQLTableManage.getInstance().get(object.getClass());
        if (table == null) {
            throw new SQLException("table \u672a\u88ab\u7ba1\u7406\u5668\u52a0\u8f7d");
        }
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        sb.append(table.getTableName()).append(" WHERE ");
        for (SQLParam param : table.getColumnParams()) {
            Field field = object.getClass().getDeclaredField(param.getName());
            if (field.get(object) == null) continue;
            sb.append(param.getColumn()).append("=");
            if (param.getType().equals(FieldType.INTEGER.getType())) {
                sb.append(Integer.parseInt(String.valueOf(field.get(object))));
                if (param.isAutoInCrement()) {
                    break;
                }
            } else if (param.getType().equals(FieldType.TEXT.getType())) {
                sb.append("'").append(field.get(object)).append("'");
            }
            sb.append(" AND ");
        }
        if ((str = sb.toString()).endsWith(" AND ")) {
            str = str.substring(0, str.length() - 5);
        }
        if ((id = this.execSQL(str)) <= 0) {
            throw new SQLException(String.format("\u5220\u9664\u8868\u6570\u636e\u5931\u8d25,\u6307\u4ee4:%s", sb.toString()));
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

