/*
 * Decompiled with CFR 0.152.
 */
package com.hellmessage.cob.session;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.hellmessage.cob.HECob;
import com.hellmessage.core.security.HEDes;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class HECobClient {
    private boolean connected = false;
    private boolean registry = false;
    private Socket client;
    private Thread handle;

    public HECobClient() {
        try {
            this.client = new Socket(HECob.getCobConfig().getCob().getHost(), HECob.getCobConfig().getCob().getPort());
            this.connected = this.client.isConnected();
            if (this.connected) {
                this.handle = new Thread(this.run());
                this.handle.start();
            }
        }
        catch (Exception e) {
            if (HECob.getCobConfig().isDebug()) {
                e.printStackTrace();
            }
            HECob.getConsole().error((Object)e.getMessage());
        }
    }

    private Runnable run() {
        return () -> {
            try {
                String data;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.client.getInputStream(), StandardCharsets.UTF_8));
                this.handleSend("COB", "registry", "registry", String.valueOf(Bukkit.getPort()), 0);
                while ((data = br.readLine()) != null) {
                    if (data.length() <= 0) continue;
                    new Thread(this.handleReceive(data)).start();
                }
                br.close();
            }
            catch (Exception e) {
                if (HECob.getCobConfig().isDebug()) {
                    e.printStackTrace();
                }
                HECob.getConsole().error((Object)e.getMessage());
            }
        };
    }

    public void autoConnect() {
        new Thread(() -> {
            int i = 1;
            while (true) {
                try {
                    do {
                        Thread.sleep(5000L);
                        HECob.getConsole().info("\u6b63\u5728\u5c1d\u8bd5\u56de\u5230\u6307\u6325\u7f51....[%s]", new Object[]{i});
                        ++i;
                        this.client = new Socket(HECob.getCobConfig().getCob().getHost(), HECob.getCobConfig().getCob().getPort());
                        this.connected = this.client.isConnected();
                    } while (!this.connected);
                    this.handle = new Thread(this.run());
                    this.handle.start();
                    HECob.getConsole().info((Object)"\u5df2\u6210\u529f\u63a5\u5165\u6307\u6325\u7f51");
                }
                catch (Exception e) {
                    this.connected = false;
                    continue;
                }
                break;
            }
        }).start();
    }

    private Runnable handleReceive(String data) {
        return () -> {
            try {
                String temp = HEDes.decrypt((String)data, (String)HECob.getCobConfig().getPass());
                JsonObject json = (JsonObject)new Gson().fromJson(temp, JsonObject.class);
                String to = json.get("to").getAsString();
                String type = json.get("type").getAsString();
                String command = json.get("command").getAsString();
                String content = json.get("content").getAsString();
                String from = json.get("from").getAsString();
                switch (type) {
                    case "registry": {
                        this.registry = true;
                        HECob.getConsole().info((Object)String.format("\u6307\u6325\u7f51\u8eab\u4efd\u6ce8\u518c\u6210\u529f \u672c\u670d\u52a1\u5668\u4ee3\u53f7:\u00a74%s", HECob.getCobConfig().getCob().getName()));
                        break;
                    }
                    case "run": {
                        Bukkit.getScheduler().runTask((Plugin)HECob.getInstance(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)json.get("command").getAsString()));
                        break;
                    }
                }
                if (type.equalsIgnoreCase("registry") || type.equalsIgnoreCase("run") || type.equalsIgnoreCase("cob listener")) {
                    HECob.getConsole().info((Object)String.format("\u63a5\u6536\u5230\u6307\u4ee4: \u7531[\u00a7e%s]\u4e0b\u8fbe\u7ed9[\u00a7e%s]\u7684\u6307\u4ee4[\u00a7e%s] \u9644\u5e26\u4fe1\u606f:[\u00a7e%s]", from, to, command, content));
                } else if (type.equalsIgnoreCase("error")) {
                    HECob.getConsole().error((Object)command);
                }
            }
            catch (Throwable e) {
                if (HECob.getCobConfig().isDebug()) {
                    e.printStackTrace();
                }
                HECob.getConsole().error((Object)e.getMessage());
            }
        };
    }

    public void handleSend(String to, String type, String command, String content, int delay) {
        try {
            if (this.isConnected()) {
                JsonObject json = new JsonObject();
                json.addProperty("to", to);
                json.addProperty("type", type);
                json.addProperty("command", command);
                json.addProperty("name", HECob.getCobConfig().getCob().getName());
                json.addProperty("content", content);
                json.addProperty("delay", (Number)delay);
                String data = HEDes.encrypt((String)json.toString().replace(System.lineSeparator(), ""), (String)HECob.getCobConfig().getPass());
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(this.client.getOutputStream(), StandardCharsets.UTF_8), true);
                pw.println(data);
                pw.flush();
            } else {
                HECob.getConsole().error((Object)"\u5df2\u6389\u51fa\u6307\u6325\u7f51 \u6d88\u606f\u65e0\u6cd5\u9001\u8fbe");
                this.autoConnect();
            }
        }
        catch (Throwable e) {
            if (HECob.getCobConfig().isDebug()) {
                e.printStackTrace();
            }
            HECob.getConsole().error((Object)e.getMessage());
        }
    }

    public boolean isConnected() {
        return this.connected;
    }
}

