/*
 * Decompiled with CFR 0.152.
 */
package com.hellmessage.core.modular.cob.session;

import com.hellmessage.core.HECore;
import com.hellmessage.core.config.HECobConfig;
import com.hellmessage.core.manage.HECobClientManage;
import com.hellmessage.core.modular.cob.session.HECobClient;
import com.hellmessage.core.tools.HEThread;
import java.net.ServerSocket;
import net.md_5.bungee.api.Callback;

public class HECobServer {
    private HECore plugin;
    private ServerSocket server;
    private HEThread serverThread;
    private HECobClientManage clientManage;
    private HECobConfig config;
    private boolean running = false;

    public HECobServer(HECore plugin, HECobConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.clientManage = new HECobClientManage();
        this.serverThread = new HEThread((Callback<HEThread>)((Callback)(a, b) -> {
            block4: {
                try {
                    this.server = new ServerSocket(config.getPort());
                    while (this.running) {
                        new HECobClient(this, this.server.accept());
                    }
                }
                catch (Exception e) {
                    if (e.getMessage().equalsIgnoreCase("socket closed")) break block4;
                    if (HECore.getConfig().isDebug()) {
                        e.printStackTrace();
                    }
                    HECore.getConsole().error("\u65e0\u6cd5\u5efa\u7acb \u5730\u72f1\u6307\u6325\u7f51 error:[\u00a7e%s]", e.getMessage());
                }
            }
        }), plugin);
    }

    public void start() {
        this.running = true;
        this.serverThread.run();
    }

    public void stop() {
        this.running = false;
        try {
            this.clientManage.close();
            this.server.close();
        }
        catch (Exception e) {
            HECore.getConsole().info("\u5df2\u505c\u6b62\u6307\u6325\u7f51");
        }
    }

    public HECobClientManage getClientManage() {
        return this.clientManage;
    }

    public HECore getPlugin() {
        return this.plugin;
    }

    public HECobConfig getConfig() {
        return this.config;
    }

    public boolean isRunning() {
        return this.running;
    }
}

