/*
 * Decompiled with CFR 0.152.
 */
package com.hellmessage.core.modular.cob.session;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.hellmessage.core.HECore;
import com.hellmessage.core.file.HEConfig;
import com.hellmessage.core.modular.cob.session.HECobServer;
import com.hellmessage.core.security.HEDes;
import com.hellmessage.core.tools.HERegex;
import com.hellmessage.core.tools.HEThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;

public class HECobClient {
    private HECobServer server;
    private String name = "\u672a\u77e5";
    private Socket client;
    private boolean bungee = false;

    public HECobClient(HECobServer server, Socket socket) {
        this.server = server;
        this.client = socket;
        HEThread clientThread = new HEThread((Callback<HEThread>)((Callback)(a, b) -> this.handleClient()), server.getPlugin());
        clientThread.run();
    }

    private void handleClient() {
        if (this.client != null && this.client.isConnected()) {
            try {
                String data;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.client.getInputStream(), StandardCharsets.UTF_8));
                while ((data = br.readLine()) != null) {
                    try {
                        data = HEDes.decrypt(data, this.server.getConfig().getPass());
                        JsonObject json = (JsonObject)new Gson().fromJson(data, JsonObject.class);
                        List<String> keys = Arrays.asList("name", "type", "command", "to");
                        for (String key : keys) {
                            if (json.has(key)) continue;
                            throw new Exception(String.format("\u952e\u503c[%s]\u4e0d\u5b58\u5728", key));
                        }
                        this.name = json.get("name").getAsString();
                        this.handleCommand(json);
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                    catch (Throwable e) {
                        if (HECore.getConfig().isDebug()) {
                            e.printStackTrace();
                        }
                        HECore.getConsole().error("\u6307\u6325\u7f51\u6570\u636e\u89e3\u5bc6\u5931\u8d25");
                    }
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void handleCommand(JsonObject json) {
        String to = json.get("to").getAsString();
        String command = json.get("command").getAsString();
        String content = json.get("content").getAsString();
        String type = json.get("type").getAsString();
        int delay = json.get("delay").getAsInt();
        new HEThread((Callback<HEThread>)((Callback)(a, b) -> {
            try {
                if (delay > 0) {
                    Thread.sleep(delay * 50);
                }
                switch (type) {
                    case "registry": {
                        this.server.getClientManage().add(this.name, this);
                        if (HERegex.isInt(content)) {
                            this.server.getPlugin().getProxy().getServers().forEach((bungeeName, server) -> {
                                if (server.getAddress().getPort() == Integer.parseInt(content)) {
                                    this.bungee = true;
                                }
                            });
                        }
                        this.send(this.server.getConfig().getName(), this.name, "registry", "cob registry ok", "run registry");
                        HECore.getConsole().info("\u65b0\u5b50\u7f51\u52a0\u5165 \u4ee3\u53f7:[\u00a7e%s] BC\u5b50\u670d:[%s] \u670d\u52a1\u5668\u7aef\u53e3:[%s]", this.name, this.bungee ? "\u662f" : "\u5426", content);
                        break;
                    }
                    case "run": {
                        this.runCommand(this.name, to, type, command, content);
                        break;
                    }
                    case "group": {
                        this.groupCommand(this.name, command, content);
                        break;
                    }
                    default: {
                        HECore.getConsole().error("\u672a\u77e5\u6307\u4ee4[%s]", type);
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }), this.server.getPlugin()).run();
    }

    public void runCommand(String from, String to, String type, String command, String content) {
        HECore.getConsole().info(String.format("\u63a5\u6536\u5230\u6307\u4ee4: \u7531[\u00a7e%s]\u4e0b\u8fbe\u7ed9[\u00a7e%s]\u7684\u6307\u4ee4[\u00a7e%s] \u9644\u5e26\u4fe1\u606f:[\u00a7e%s]", from, to, command, content));
        if (to.equalsIgnoreCase("global")) {
            this.server.getClientManage().getList().forEach((k, v) -> {
                if (v.getClient().isConnected()) {
                    v.send(from, to, type, command, content);
                }
            });
        } else {
            HECobClient temp = this.server.getClientManage().get(to);
            if (temp != null && temp.getClient().isConnected()) {
                temp.send(from, to, type, command, content);
            }
        }
    }

    public void groupCommand(String from, String command, String content) throws IOException {
        HECore.getConsole().info(String.format("\u63a5\u6536\u5230\u6307\u4ee4: \u7531[\u00a7e%s]\u4e0b\u8fbe\u7684\u6307\u4ee4\u7ec4[\u00a7e%s] \u9644\u5e26\u4fe1\u606f:[\u00a7e%s]", from, command, content));
        Configuration group = HEConfig.get((Plugin)this.server.getPlugin(), String.format("%s.yml", command), "commands");
        if (group != null) {
            group.getKeys().forEach(name -> {
                List commands = group.getStringList(name);
                if (name.equalsIgnoreCase("global")) {
                    this.server.getClientManage().getList().forEach((key, client) -> this.handleGroup(from, (HECobClient)client, (List<String>)commands));
                } else {
                    new HEThread((Callback<HEThread>)((Callback)(c, d) -> {
                        HECobClient client = this.server.getClientManage().get((String)name);
                        if (client != null) {
                            this.handleGroup(from, client, (List<String>)commands);
                        } else {
                            this.handleGroup(from, (String)name, (List<String>)commands);
                        }
                    }), this.server.getPlugin()).run();
                }
            });
        } else {
            String error = String.format("\u8fd0\u884c\u6307\u4ee4\u7ec4\u5931\u8d25, \u7531\u4e8eBC\u63d2\u4ef6\u914d\u7f6e[commands]\u76ee\u5f55\u4e0b\u6ca1\u6709[%s.yml]\u914d\u7f6e\u6587\u4ef6", command);
            this.send(this.server.getConfig().getName(), this.name, "error", error, "show error");
            HECore.getConsole().error("\u8fd0\u884c\u6307\u4ee4\u7ec4\u5931\u8d25, \u7531\u4e8e[commands]\u76ee\u5f55\u4e0b\u6ca1\u6709[%s.yml]\u914d\u7f6e\u6587\u4ef6", command);
        }
    }

    public void handleGroup(String from, String to, List<String> commands) {
        commands.forEach(command -> {
            if (command.startsWith("[run] ")) {
                this.runCommand(from, to, "run", command.replace("[run] ", ""), "run command");
                return;
            }
            if (command.startsWith("[delay] ")) {
                try {
                    Thread.sleep(Integer.parseInt(command.replace("[delay] ", "")) * 50);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void handleGroup(String from, HECobClient client, List<String> commands) {
        String to = client.getName();
        commands.forEach(command -> {
            if (command.startsWith("[run] ")) {
                if (client.getClient().isConnected()) {
                    client.send(from, to, "run", command.replace("[run] ", ""), "run command");
                }
                return;
            }
            if (command.startsWith("[delay] ")) {
                try {
                    Thread.sleep(Integer.parseInt(command.replace("[delay] ", "")) * 50);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void send(String from, String to, String type, String command, String content) {
        try {
            JsonObject json = new JsonObject();
            json.addProperty("from", from);
            json.addProperty("to", to);
            json.addProperty("type", type);
            json.addProperty("command", command);
            json.addProperty("content", content);
            String data = HEDes.encrypt(json.toString(), this.server.getConfig().getPass());
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(this.client.getOutputStream(), StandardCharsets.UTF_8), true);
            pw.println(data.replace(System.lineSeparator(), ""));
            pw.flush();
        }
        catch (IOException e) {
            if (!type.equalsIgnoreCase("error")) {
                HECore.getConsole().error("\u7531[\u00a7e%s]\u7ed9[\u00a7e%s]\u7684\u6307\u4ee4[\u00a7e%s]\u4e0b\u8fbe\u5931\u8d25 error:[\u00a7e%s]", from, to, command, e.getMessage());
            }
        }
        catch (Throwable e) {
            if (HECore.getConfig().isDebug()) {
                e.printStackTrace();
            }
            HECore.getConsole().error("\u6307\u6325\u7f51\u6570\u636e\u52a0\u5bc6\u5931\u8d25");
        }
    }

    public void close() {
        if (this.client != null) {
            block5: {
                try {
                    if (!this.client.isConnected()) break block5;
                    this.client.shutdownInput();
                    this.client.shutdownOutput();
                    this.client.close();
                }
                catch (Exception e) {
                    try {
                        this.handleException(e);
                    }
                    catch (Throwable throwable) {
                        HECore.getConsole().info("\u5df2\u5173\u95ed\u5b50\u7f51[%s]", this.name);
                        throw throwable;
                    }
                    HECore.getConsole().info("\u5df2\u5173\u95ed\u5b50\u7f51[%s]", this.name);
                }
            }
            HECore.getConsole().info("\u5df2\u5173\u95ed\u5b50\u7f51[%s]", this.name);
        }
        this.server.getClientManage().remove(this.name);
    }

    private void handleException(Exception e) {
        if (e.getMessage().equalsIgnoreCase("Socket is closed")) {
            return;
        }
        if (e.getMessage().equalsIgnoreCase("Socket closed")) {
            return;
        }
        if (e.getMessage().equals("Connection reset")) {
            HECore.getConsole().info("\u5b50\u670d \u00a77[\u00a7e\u00a7l%s\u00a77] \u00a7b\u8131\u79bb\u4e86\u5730\u72f1\u6307\u6325\u7f51\uff0c\u5760\u5165\u4e86\u6df1\u6e0a\u4e4b\u4e2d", this.name);
            return;
        }
        if (HECore.getConfig().isDebug()) {
            e.printStackTrace();
        }
        HECore.getConsole().error("\u5b50\u7f51\u901a\u8baf\u5931\u8d25 error:[\u00a7e%s]", e.getMessage());
    }

    public Socket getClient() {
        return this.client;
    }

    public String getName() {
        return this.name;
    }
}

