/*
 * Decompiled with CFR 0.152.
 */
package com.hellmessage.core.file;

import com.hellmessage.core.annotation.HEBranch;
import com.hellmessage.core.annotation.HEEntity;
import com.hellmessage.core.annotation.HENode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class HEConfig {
    private Plugin plugin;
    private String file;
    private String path;

    public HEConfig(Plugin plugin, String file) {
        this.plugin = plugin;
        this.file = file;
    }

    public HEConfig(Plugin plugin, String file, String path) {
        this.plugin = plugin;
        this.file = file;
        this.path = path;
    }

    private Configuration get() throws IOException {
        File file;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        String name = this.file;
        if (this.path != null && !this.path.isEmpty()) {
            name = String.format("%s/%s", this.path, this.file);
            File path = new File(this.plugin.getDataFolder(), this.path);
            if (!path.exists()) {
                path.mkdirs();
            }
        }
        if (!(file = new File(this.plugin.getDataFolder(), name)).exists()) {
            try {
                InputStream in = this.plugin.getResourceAsStream(name);
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
        return ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(this.plugin.getDataFolder(), name));
    }

    public static Configuration get(Plugin plugin, String file) throws IOException {
        return new HEConfig(plugin, file).get();
    }

    public static Configuration get(Plugin plugin, String file, String path) throws IOException {
        return new HEConfig(plugin, file, path).get();
    }

    public static <T> T get(Plugin plugin, Configuration config, Class<T> cs) throws Exception {
        String base = "";
        HENode node = cs.getAnnotation(HENode.class);
        if (node != null) {
            base = String.format("%s.", node.value());
        }
        return HEConfig.handleClass(plugin, config, base, cs);
    }

    public static <T> T get(Plugin plugin, Class<T> cs) throws Exception {
        String path;
        HEEntity entity = cs.getAnnotation(HEEntity.class);
        if (entity == null) {
            return null;
        }
        String name = entity.value();
        Configuration config = HEConfig.get(plugin, name, path = entity.path());
        if (config == null) {
            return null;
        }
        String base = "";
        HENode node = cs.getAnnotation(HENode.class);
        if (node != null) {
            base = String.format("%s.", node.value());
        }
        return HEConfig.handleClass(plugin, config, base, cs);
    }

    private static <T> T handleClass(Plugin plugin, Configuration config, String base, Class<T> cs) throws Exception {
        T object = cs.newInstance();
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            HEBranch branch = field.getAnnotation(HEBranch.class);
            if (branch != null && !branch.value().isEmpty()) {
                field.set(object, HEConfig.getBranch(plugin, config, String.format("%s%s.", base, branch.value()), field.getType()));
                continue;
            }
            HENode node = field.getAnnotation(HENode.class);
            if (node == null || node.value().isEmpty()) continue;
            field.set(object, config.get(String.format("%s%s", base, node.value()), field.get(object)));
        }
        return object;
    }

    private static <T> T getBranch(Plugin plugin, Configuration config, String base, Class<T> cs) throws Exception {
        HENode node = cs.getAnnotation(HENode.class);
        if (node != null) {
            base = String.format("%s%s.", base, node.value());
        }
        return HEConfig.handleClass(plugin, config, base, cs);
    }
}

